/*
  Planet isosurface from Jaime Vives Piqueres's moon.

*/
#version 3.5;
global_settings{
 assumed_gamma 1.0
 max_trace_level 20
}
#default{texture{finish{ambient 0}}}
#include "functions.inc"

// Standard pre-defined colors
//
#include "colors.inc"
#include "Galaxy.inc"      

#declare Modelling=off; 

#declare showGalaxy=on; 
#declare ShowPlanet=on;
#declare ShowWater=on;
#declare ShowClouds=on; 
#declare ShowRings=on;

// *** STARFIELD *** \\
sky_sphere {pigment {star_pig scale .1}}


// *** PLANET ***

// planet texture
#declare t_planet=
texture{
 pigment{
  onion    warp { turbulence 0.1 /*lambda 33 */ } 
  color_map{ 
   //[.5 rgb <.3,.2,.05>] // sand   
   [.7 rgb <.3,.2,.05>] // sand
   //[0.8 rgb <.2,.1,.01>]   // ground
   [.8 rgb <0,.1,0>]    // green
   [.99 rgb <.1,.05,.01>]//<.1,.2,.01>]      // green
   }
 }
}


// Cloud texture
#declare t_clouds=
texture{
         pigment{
                  granite scale <100,80,100>   
                  turbulence <1,.2,1> 
                  //lambda 2.5  
                  //omega .6 
                  warp { turbulence <10,0,10>*.1 
                        //lambda 3 
                        //omega .7
                        }
                  color_map{ 
                           [.3 rgb 1 transmit 1]  
                           [.9 rgb 1 transmit .5 ]
                           [1.0 rgb 1 transmit 0]
                          }
                 
                 }
        }
#declare t_clouds2=
texture{
         pigment{
                  granite scale <70,50,70>   
                  turbulence .3 lambda 5   
                  //warp { turbulence 0.1 }
                  color_map{ 
                           [.5 rgb 1 transmit 1]  
                           //[.7 rgb 1 transmit .5 ]
                           [1.0 rgb 1 transmit .3]
                          }
                 }
        }

// Planet
#declare Planet= 
union{
        isosurface{  // Copied from Jaime's LightSys Space Demo scene
                 function{(x*x+y*y+z*z-1)+f_granite(x*2,y*2,z*2)*f_agate(x,y,z)*.05}
                 max_gradient 3.8
                 contained_by{sphere{0,1}}
                 texture{t_planet scale .02}
                }


       #if(ShowWater)
               sphere{0,1 // water
                      pigment{rgb <0,.05,.2> transmit .3*(!Modelling) } 
                      finish{specular .2  metallic}  
                      #if(!Modelling)
                      interior{fade_distance .003 fade_color rgb <0,0,.1>} 
                      #end
                      scale .996
                      }
       #end
      #if(!Modelling)
              sphere{0,1 // Atmosphere
                      pigment{colour rgbt 1}  
                      interior{
                               media {
                                          // (---general values---)
                                          intervals 10           // number of intervals used for sampling [10]
                                          samples 1,1            // minimum and maximum number of samples taken per interval [1,1]
                                          confidence 0.9         // statistic parameter higher->better quality [0.9]
                                          variance 1.0/128       // statistic parameter lower->better quality [1.0/128]
                                          ratio 0.9              // distribution between lit and unlit areas [0.9]
                                          // (---media types---)
                                          //absorption rgb<.1,.05,0>*.001  // absorbing media, block light of specified color
                                          scattering {           // scattering media
                                            2,                   // scattering type 1=isotropic; 2=Mie haze; 3=Mie murky
                                                                 // 4=Rayleigh; 5=Henyey-Greenstein
                                            rgb 10           // color
                                          }
                                          //method 3               // adaptive sampling
                                          density {
                                                   // spherical  
                                                   onion    


                                                  color_map{ 
                                                           [.89 rgb 1]    // earth
                                                           [.93 rgb <0,.5,.6>]//  
                                                           [.98 rgb <0,0,.1>]// 
                                                           [1 rgb 0 ]//
                                                           }
                                                  }
                                        
                                        }
        
        
                               } 
                      rotate y*90        
                      scale 1.05 
                      hollow
                      double_illuminate
                      }
       #end  
       #if(ShowClouds)
               union{
                      sphere{0,1.01 texture{t_clouds scale <0.021,0.02,0.021>}}
                       
                      rotate y*45 
                      hollow //double_illuminate
                      }  
        #end      
       } 
        
// placement 
union{  #if(ShowRings)      
        disc {<0, 0, 0>  y, 1.0, .7        // -O- RINGs -O-
                        pigment{spherical 
                                cubic_wave 
                                colour_map{
                                           [0 rgbft <0,0,0, 1,1>]  
                                           [.01 rgbft <.4,.3,.2, 0,.1>] 
                                           [.015 rgbft <.3,.3,.3, .1,.7>] 
                                           [.03 rgbft <.35,.25,.2, 0,.1>]
                                           [.04 rgbft <.1,.21,.3, .1,.8>]
                                           //[.05 rgbft <.35,.25,.2, 0,.1>]  
                                           //[.06 rgbft <.1,.21,.3, .1,.8>] 
                                           [.08 rgbft <.3,.21,.1, .2,.9>]
                                           //[.10 rgbft <.15,.2,.25,0, .1>] //
                                           //[.12 rgbft <.3,.21,.1, .1,.8>]
                                           //[.14 rgbft <.2,.2,.2, .2,.9>]
                                           //[.15 rgbft <.25,.2,.15, 0,.1>] 
                                           //[.16 rgbft <.2,.2,.2, .2,.9>]
                                           [.11 rgbft <.25,.2,.15, 0,.1>]  
                                           [.18 rgbft <.2,.2,.2, .1,.7>] 
                                           [.20 rgbft <.3,.2,.1, 0,.1>]
                                           [.22 rgbft <0,0,0, 1,1>]
                                           }
                                }  
                        scale 2
                        hollow 
                        double_illuminate
                        rotate <-15,0,0>
                        }
         #end               
        object{Planet }
        scale .3 translate <0,0,1>}
        light_source{
         0
         3
         fade_power 2
         translate 10e4*x  
         rotate <0,0,25>
         //rotate 360*rand(r_sun)*x
         //rotate 360*rand(r_sun)*y
        }




// Agnesi   
quartic 
  {<  0,   0,   0,   0,   0,   0,   1,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   1,   0,   0.04,
      0,   0,   0,   0,   0.04>
  // material {} is a wrapper for interior and texture
// you can declare it like texture and interior too
// Note that it has nothing to do with material_map
material{texture {
         checker   
            texture {  // Mainly transparent
               pigment {rgbft <0,0,0,0,1> }
               
               finish { reflection {0,.5}}
            } // texture
            
            texture {  // Mainly reflective
               pigment {rgbft <0,0,0,.5,.2>  }
               finish { reflection {.5,.9}} 
            } scale .4
          } // texture 
          //interior {ior 1.31  }
          
          rotate y*30
          translate x*.5
         } // material
  scale .8
  translate <0,-.3,1>
  hollow double_illuminate
  }


#if(showGalaxy)

object{Galaxy(0,1 ) rotate x*90
        scale <5,.5,5>
        translate <0,-1,2>
         }
          
#end 


camera{
 location <0,1,-3>*1.5
 direction z*3
 look_at <0,-.4,1>
}
